/*
 * Decompiled with CFR 0.152.
 */
package kn.uni.cls.commands;

import ij.ImagePlus;
import ij.plugin.FolderOpener;
import ij.process.ImageConverter;
import kn.uni.cls.ops.adjust_contrast.Adjust8BitContrastOp;
import kn.uni.cls.ops.external.NaturalizationOp;
import kn.uni.cls.ops.findedges.FindEdgesOp;
import kn.uni.cls.ops.threshold.ThresholdOp;
import kn.uni.cls.utils.FormatConverter;
import kn.uni.cls.utils.Messages;
import net.imagej.Dataset;
import net.imagej.display.ImageDisplayService;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.type.numeric.RealType;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.convert.ConvertService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.UIService;

@Deprecated
public class DeprecatedCommand<T extends RealType<T>>
implements Command {
    @Parameter(required=false)
    private Dataset currentData;
    @Parameter
    private Context context;
    @Parameter
    private UIService uiService;
    static final int THRESHOLD_LOWER_DEFAULT = 0;
    static final int THRESHOLD_UPPER_DEFAULT = 8;
    static final double PARTICLES_MIN = 0.0;
    static final double PARTICLES_MAX = 0.75;
    private ImagePlus imagePlus;
    private int lowerThresholdBound = 0;
    private int higherThresholdBound = 8;

    public static final String getName() {
        return "BrainacleJ";
    }

    public void run() {
    }

    boolean prepareImage() {
        Dataset active = ((ImageDisplayService)this.context.getService(ImageDisplayService.class)).getActiveDataset();
        if (active == null || active.getDepth() == 1L) {
            Messages.log("No suitable image open. Please, import Image Sequence.");
            ImagePlus stack = FolderOpener.open(null);
            if (stack == null) {
                return false;
            }
            if (stack.getNSlices() < 2) {
                Messages.log("A sequence of images is expected.");
                return false;
            }
            this.currentData = FormatConverter.imagePlusToDataset(stack, this.context);
            return true;
        }
        this.currentData = active;
        return true;
    }

    void execute() {
        this.syncImagePlus();
        Messages.log("Processing input slices...");
        this.doFindEdgesStep();
        this.doAdjustContrastStep();
        this.doNaturalizationStep();
        this.doThresholdStep();
        this.uiService.show((Object)this.imagePlus);
    }

    void setThreshold(int lower, int upper) {
        this.lowerThresholdBound = lower;
        this.higherThresholdBound = upper;
    }

    private void doFindEdgesStep() {
        Messages.log("Find Edges Step...");
        FindEdgesOp step = new FindEdgesOp(this.currentData);
        step.setContext(this.context);
        step.execute();
        Messages.log("... Done.");
        this.syncImagePlus();
    }

    private void doAdjustContrastStep() {
        this.setByteType();
        Messages.log("Adjust Contrast Step...");
        Adjust8BitContrastOp step = new Adjust8BitContrastOp(this.imagePlus);
        step.execute();
        Messages.log("... Done.");
    }

    private void doNaturalizationStep() {
        Messages.log("Naturalization Step...");
        NaturalizationOp step = new NaturalizationOp(this.imagePlus, 3);
        step.execute();
        Messages.log("... Done.");
    }

    private void doThresholdStep() {
        Messages.log("Thresholding Step...");
        ThresholdOp step = new ThresholdOp(this.imagePlus);
        step.setBounds(this.lowerThresholdBound, this.higherThresholdBound);
        step.execute();
        Messages.log("... Done.");
        this.updateDatasetImage();
    }

    private void setByteType() {
        Messages.log("Changing to 8-Bit...");
        ImageConverter converter = new ImageConverter(this.imagePlus);
        converter.convertToGray8();
        Messages.log("... Done.");
    }

    @Deprecated
    private void syncDataset() {
        this.currentData = FormatConverter.imagePlusToDataset(this.imagePlus, this.context);
    }

    private void syncImagePlus() {
        this.imagePlus = FormatConverter.datasetToImagePlus(this.currentData, (ConvertService)this.context.getService(ConvertService.class));
    }

    private void updateDatasetImage() {
        this.currentData.setImgPlus(ImagePlusAdapter.wrapImgPlus((ImagePlus)this.imagePlus));
    }

    private void checkCondition(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

