/*
 * Decompiled with CFR 0.152.
 */
package kn.uni.cls.commands.delete_selection;

import fiji.selection.Select_Bounding_Box;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Toolbar;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import kn.uni.cls.utils.Messages;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BrainacleJ>Delete (guess backgound color)")
public class DeleteSelectionCommand
extends ContextCommand {
    public void run() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            Messages.noImageError();
            return;
        }
        if (imagePlus.getRoi() == null) {
            Messages.showError("First select area to delete.");
            return;
        }
        Color bgColor = null;
        Color previousBgColor = Toolbar.getBackgroundColor();
        ImageProcessor ip = imagePlus.getStack().getProcessor(1);
        if (imagePlus.getDisplayRangeMax() == 1.0) {
            Messages.showHTMLMessage("Floating-point image!", "Use <b>Image</b> &#10146; <b>Type</b> to convert your image.");
            return;
        }
        int bg = (int)new Select_Bounding_Box().guessBackground(ip);
        if (DeleteSelectionCommand.isSupported(ip)) {
            bgColor = ip.isGrayscale() ? new Color(bg, bg, bg) : DeleteSelectionCommand.toRGB32(ip.getColorModel().getRGB(bg) & 0xFFFFFF);
        } else {
            Messages.showError("Unsupported image format!");
            return;
        }
        bgColor = imagePlus.isInvertedLut() ? DeleteSelectionCommand.invertRGB(bgColor) : bgColor;
        Toolbar.setBackgroundColor((Color)bgColor);
        IJ.run((ImagePlus)imagePlus, (String)"Clear", (String)"stack");
        Toolbar.setBackgroundColor((Color)previousBgColor);
    }

    private static boolean isSupported(ImageProcessor ip) {
        HashSet<Integer> formats = new HashSet<Integer>();
        formats.addAll(Arrays.asList(32, 8, 16, 24));
        return formats.contains(ip.getBitDepth());
    }

    public static Color toRGB32(int color32) {
        return new Color(color32 >> 16, color32 >> 8 & 0xFF, color32 & 0xFF);
    }

    public static Color toRGB16(int color16) {
        return new Color(color16 >> 10, color16 >> 5 & 0x1F, color16 & 0x1F);
    }

    public static Color toRGB8(int color8) {
        return new Color(color8 >> 5, color8 >> 2 & 7, color8 & 7);
    }

    private static Color invertRGB(Color c) {
        return new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
    }
}

