/*
 * Decompiled with CFR 0.152.
 */
package kn.uni.cls.commands.export_surfaces;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.process.StackConverter;
import ij3d.Content;
import ij3d.Executer;
import ij3d.Image3DUniverse;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import kn.uni.cls.commands.export_surfaces.SurfacesExporter;
import kn.uni.cls.utils.Messages;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Tuple3d;

@Plugin(type=Command.class, menuPath="File>Export>Surface Mesh")
public class ExportSurfacesCommand
extends ContextCommand {
    @Parameter
    private UIService ui;
    private static final String MOBJ = ".mobj";
    private static final String OBJ = ".obj";

    public void run() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus.getNDimensions() < 3) {
            this.cancel("<html>No stack image found!<p>Use <b>File</b> &#10146; <b>Import</b> &#10146; <b>Image Sequence...</b> to import stack image.</p></html>");
            return;
        }
        Image3DUniverse universe = new Image3DUniverse();
        this.closeConsole();
        if (imagePlus.getType() != 0) {
            new StackConverter(imagePlus).convertToGray8();
        }
        final GenericDialog gd = new GenericDialog("Export Information");
        gd.addChoice("Export Format", ExportSurfacesCommand.getSupportedFormats(), ExportSurfacesCommand.getSupportedFormats()[0]);
        gd.addNumericField("Threshold Value", (double)Content.getDefaultThreshold((ImagePlus)imagePlus, (int)2), 0);
        gd.addNumericField("Resampling Factor", (double)Content.getDefaultResamplingFactor((ImagePlus)imagePlus, (int)2), 0);
        gd.addMessage("\n\n");
        this.showMetaToUI(gd);
        final Choice choice = (Choice)gd.getChoices().get(0);
        choice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (choice.getSelectedItem().equals(ExportSurfacesCommand.OBJ)) {
                    ExportSurfacesCommand.this.hideMetaFromUI(gd, 7, 5);
                } else {
                    gd.remove(gd.getComponent(gd.getComponentCount() - 1));
                    ExportSurfacesCommand.this.showMetaToUI(gd);
                }
                gd.showDialog();
            }
        });
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int threshold = (int)gd.getNextNumber();
        int resFactor = (int)gd.getNextNumber();
        universe.addContent(imagePlus, null, imagePlus.getTitle(), threshold, new boolean[]{true, true, true}, resFactor, 2);
        File file = Executer.promptForFile((String)"Save Mesh", (String)"untitled", (String)OBJ);
        if (file == null) {
            this.cancel("No file!");
            return;
        }
        if (choice.getSelectedItem().equals(ExportSurfacesCommand.getSupportedFormats()[0])) {
            this.saveMobjFile(file, this.buildMetaInformation(gd, imagePlus, universe));
        }
        SurfacesExporter.saveAsWaveFront(universe.getContents(), file);
        universe.removeAllContents();
        universe = null;
        Messages.showMessage("Successfully exported surfaces to " + file.getAbsolutePath());
    }

    private void closeConsole() {
        Object console = this.ui.getDefaultUI().getConsolePane().getComponent();
        while (!(console instanceof Window)) {
            console = ((Component)console).getParent();
        }
        ((Window)console).setVisible(false);
    }

    private void showMetaToUI(GenericDialog gd) {
        gd.addNumericField("Voxel size", 1.0, 4);
        gd.addStringField("Unit of length", "pixel");
    }

    private void hideMetaFromUI(GenericDialog gd, int startIndex, int length) {
        length += startIndex;
        int index = startIndex;
        while (startIndex++ < length) {
            gd.remove(gd.getComponent(index));
        }
    }

    private void saveMobjFile(File obj, String[] meta) {
        String mobjFilename = String.valueOf(obj.getName().substring(0, obj.getName().lastIndexOf(46))) + MOBJ;
        File mobj = new File(obj.getParentFile(), mobjFilename);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(mobj)), "8859_1");){
                ExportSurfacesCommand.writeMeta(writer, meta);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Messages.showError("There was problem writing meta information.");
            e.printStackTrace();
        }
    }

    private String[] buildMetaInformation(GenericDialog gd, ImagePlus image, Image3DUniverse universe) {
        Content mesh = (Content)universe.contents().next();
        Point3d min = new Point3d();
        Point3d max = new Point3d();
        mesh.getContent().getMin((Tuple3d)min);
        mesh.getContent().getMax((Tuple3d)max);
        return new String[]{"voxel " + gd.getNextNumber() + "\n", "voxel-unit " + gd.getNextString() + "\n", "pixels " + image.getWidth() + " " + image.getHeight() + " " + image.getNSlices() + "\n", "min " + min.x + " " + min.y + " " + min.z + "\n", "max " + max.x + " " + max.y + " " + max.z + "\n"};
    }

    private static void writeMeta(Writer mobj, String[] meta) throws IOException {
        mobj.write("# Meta OBJ (created with BrainacleJ)\n");
        String[] stringArray = meta;
        int n = meta.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            mobj.write(line);
            ++n2;
        }
        mobj.write("---\n");
    }

    public static String[] getSupportedFormats() {
        return new String[]{".obj and .mobj", OBJ};
    }
}

