/*
 * Decompiled with CFR 0.152.
 */
package kn.uni.cls.commands.export_surfaces;

import customnode.CustomMeshNode;
import customnode.CustomMultiMesh;
import customnode.WavefrontExporter;
import ij.IJ;
import ij3d.Content;
import ij3d.ContentNode;
import isosurface.MeshGroup;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import kn.uni.cls.utils.Messages;
import orthoslice.OrthoGroup;
import surfaceplot.SurfacePlotGroup;
import voltex.VoltexGroup;

public class SurfacesExporter {
    private SurfacesExporter() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveAsWaveFront(Collection<Content> contents_, File obj_file) {
        if (contents_ == null || contents_.size() == 0) {
            return;
        }
        Collection<Content> contents = SurfacesExporter.filterMeshes(contents_);
        if (contents.size() == 0) {
            Messages.log("No meshes to export!");
            return;
        }
        String obj_filename = obj_file.getName();
        String mtl_filename = String.valueOf(obj_filename.substring(0, obj_filename.lastIndexOf(46))) + ".mtl";
        File mtl_file = new File(obj_file.getParentFile(), mtl_filename);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                OutputStreamWriter dos_obj = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(obj_file)), "8859_1");
                try {
                    try (OutputStreamWriter dos_mtl = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(mtl_file)), "8859_1");){
                        SurfacesExporter.writeAsWaveFront(contents, mtl_filename, dos_obj, dos_mtl);
                        dos_obj.flush();
                        dos_obj.flush();
                    }
                    if (dos_obj == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (dos_obj == null) throw throwable;
                    dos_obj.close();
                    throw throwable;
                }
                dos_obj.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String[] getWaveFrontData(Collection<Content> contents, String mtl_filename) {
        StringWriter sw_obj = new StringWriter();
        StringWriter sw_mtl = new StringWriter();
        try {
            SurfacesExporter.writeAsWaveFront(contents, mtl_filename, sw_obj, sw_mtl);
            return new String[]{sw_obj.toString(), sw_mtl.toString()};
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static void writeAsWaveFront(Collection<Content> contents, String mtl_filename, Writer w_obj, Writer w_mtl) throws IOException {
        HashMap<String, Object> meshes = new HashMap<String, Object>();
        for (Content mob : contents) {
            ContentNode node = mob.getContent();
            if (node instanceof CustomMultiMesh) {
                CustomMultiMesh multi = (CustomMultiMesh)node;
                int i = 0;
                while (i < multi.size()) {
                    meshes.put(String.valueOf(mob.getName()) + " [" + (i + 1) + "]", multi.getMesh(i));
                    ++i;
                }
                continue;
            }
            if (node instanceof CustomMeshNode) {
                meshes.put(mob.getName(), ((CustomMeshNode)node).getMesh());
                continue;
            }
            if (node instanceof MeshGroup) {
                meshes.put(mob.getName(), ((MeshGroup)node).getMesh());
                continue;
            }
            Messages.log("Ignoring " + mob.getName() + " with node of class " + node.getClass());
        }
        WavefrontExporter.save(meshes, (String)mtl_filename, (Writer)w_obj, (Writer)w_mtl);
    }

    public static boolean saveToFile(File f, String data) {
        if (f == null) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStreamWriter dos = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(f), data.length()), "8859_1");){
                dos.write(data, 0, data.length());
                dos.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IJ.showMessage((String)"ERROR: Most likely did NOT save your file.");
            return false;
        }
        return true;
    }

    private static Collection<Content> filterMeshes(Collection<Content> contents) {
        return contents.stream().filter(c -> !(c.getContent() instanceof VoltexGroup) && !(c.getContent() instanceof OrthoGroup) && !(c.getContent() instanceof SurfacePlotGroup)).collect(Collectors.toCollection(ArrayList::new));
    }
}

