/*
 * Decompiled with CFR 0.152.
 */
package kn.uni.cls.ops.adjust_contrast;

import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageStatistics;
import kn.uni.cls.ops.Operation;
import kn.uni.cls.utils.Messages;

public class Adjust8BitContrastOp
implements Operation {
    private ImagePlus imagePlus;
    private static final int AUTO_THRESHOLD = 5000;
    private int autoThreshold = 5000;
    private double min = -1.0;
    private double max = -1.0;
    private static final int MAX = 8;

    public Adjust8BitContrastOp(ImagePlus imagePlus) {
        this.imagePlus = imagePlus;
    }

    @Override
    public void execute() {
        this.min = this.imagePlus.getDisplayRangeMin();
        this.max = this.imagePlus.getDisplayRangeMax();
        int i = 0;
        while (this.min == this.imagePlus.getDisplayRangeMin() && this.max == this.imagePlus.getDisplayRangeMax() && i < 8) {
            this.autoAdjust8Bit(this.imagePlus);
            ++i;
        }
        if (i == 8) {
            IJ.showMessage((String)"Adjust: maximum number of iterations reached.\nImage may be unchanged.");
        } else {
            Messages.log("New minimum is " + this.min + ", new maximum is " + this.max);
        }
        int j = 1;
        while (j <= this.imagePlus.getNSlices()) {
            this.imagePlus.setSliceWithoutUpdate(j);
            this.imagePlus.setDisplayRange(this.min, this.max);
            ++j;
        }
        this.imagePlus.setSliceWithoutUpdate(1);
        this.imagePlus.updateAndDraw();
    }

    private void autoAdjust8Bit(ImagePlus imagePlus) {
        int count;
        ImageStatistics stats = imagePlus.getRawStatistics();
        int limit = stats.pixelCount / 10;
        int[] histogram = stats.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? 5000 : this.autoThreshold / 2;
        int threshold = stats.pixelCount / this.autoThreshold;
        boolean hhit = false;
        int i = -1;
        do {
            boolean bl = hhit = (count = histogram[++i]) > threshold && count <= limit;
        } while (!hhit && i < 255);
        int hmin = i;
        i = 256;
        do {
            boolean bl = hhit = (count = histogram[--i]) > threshold && count <= limit;
        } while (!hhit && i > 0);
        int hmax = i;
        if (hmax >= hmin) {
            this.min = hmin;
            this.max = hmax;
        }
    }
}

