/*
 * Decompiled with CFR 0.152.
 */
package kn.uni.cls.ops.external;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import kn.uni.cls.ops.Operation;
import mosaic.plugins.Naturalization;

public class NaturalizationOp
implements Operation {
    private ImagePlus imagePlus = null;
    private int aChannelNumber = -1;

    public NaturalizationOp(ImagePlus imagePlus, int aChannelNumber) {
        this.imagePlus = imagePlus;
        this.aChannelNumber = aChannelNumber;
    }

    @Override
    public void execute() {
        NaturalizationOp.processImageStack(this.imagePlus, this.aChannelNumber);
    }

    public static void run() {
        ImagePlus active = IJ.getImage();
        new NaturalizationOp(active, 3).execute();
    }

    public static void processImageStack(ImagePlus imagePlus, int aChannelNumber) {
        Naturalization naturalization = new Naturalization();
        int nSlices = imagePlus.getNSlices();
        ImageStack stack = imagePlus.getImageStack();
        ImageStack out = new ImageStack(stack.getWidth(), stack.getHeight());
        int i = 1;
        while (i <= nSlices) {
            ByteProcessor byteImage = stack.getProcessor(i).convertToByteProcessor();
            naturalization.processImg(byteImage, (ByteProcessor)byteImage.duplicate(), aChannelNumber);
            out.addSlice((ImageProcessor)byteImage);
            ++i;
        }
        imagePlus.setStack(out);
    }

    public static void processSingleImage(ImagePlus imagePlus, int aChannelNumber) {
        Naturalization naturalization = new Naturalization();
        ByteProcessor byteImage = imagePlus.getChannelProcessor().convertToByteProcessor();
        naturalization.processImg(byteImage, (ByteProcessor)byteImage.duplicate(), aChannelNumber);
        imagePlus.setProcessor((ImageProcessor)byteImage);
    }
}

