/*
 * Decompiled with CFR 0.152.
 */
package kn.uni.cls.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static Field extractField(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    public static Object extractFieldValue(Object obj, String fieldName) {
        try {
            Field field = ReflectionHelper.extractField(obj, fieldName);
            return field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            return null;
        }
    }

    public static boolean setField(Field field, Object obj, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean invokeMethod(String methodName, Object obj, Object ... args) {
        try {
            Method method;
            Class[] classes = null;
            if (args.length != 0) {
                classes = new Class[args.length];
                int i = 0;
                while (i < args.length) {
                    classes[i] = args[i].getClass();
                    ++i;
                }
                method = obj.getClass().getMethod(methodName, classes);
            } else {
                method = obj.getClass().getMethod(methodName, new Class[0]);
            }
            method.setAccessible(true);
            if (classes == null) {
                method.invoke(obj, new Object[0]);
            } else {
                method.invoke(obj, args);
            }
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
    }
}

