/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.macro.Interpreter;
import ij.measure.ResultsTable;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TreeMap;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class Naturalization {
    public static final int CHANNEL_R = 0;
    public static final int CHANNEL_G = 1;
    public static final int CHANNEL_B = 2;
    public static final int CHANNEL_8G = 3;
    private static final float EPS = 1.0E-4f;
    private static final float T1_pr = 0.3754f;
    private static final int N_Lap = 2041;
    private static final int Lap_Offset = 1020;
    private static final int N_Grad = 512;
    private static final int Grad_Offset = 256;
    private final float[] T2_pr = new float[]{0.2421f, 0.255f, 0.2474f, 0.24816667f};
    private final Map<Integer, Map<Integer, Float>> iPsnrOutput = new TreeMap<Integer, Map<Integer, Float>>();

    private synchronized void addPsnr(int aSlice, int aChannel, float aValue) {
        Map<Integer, Float> map = this.iPsnrOutput.get(aSlice);
        boolean isNewMap = false;
        if (map == null) {
            map = new TreeMap<Integer, Float>();
            isNewMap = true;
        }
        map.put(aChannel, Float.valueOf(aValue));
        if (isNewMap) {
            this.iPsnrOutput.put(aSlice, map);
        }
    }

    public void processImg(ByteProcessor aOutputImg, ByteProcessor aOrigImg, int aChannelNumber) {
        ImagePlus naturalizedImg = this.naturalize8bitImage(aOrigImg, aChannelNumber);
        aOutputImg.setPixels(naturalizedImg.getProcessor().getPixels());
    }

    public void displayStatisticsTable() {
        ResultsTable rs = new ResultsTable();
        for (Map.Entry<Integer, Map<Integer, Float>> e : this.iPsnrOutput.entrySet()) {
            rs.incrementCounter();
            for (Map.Entry<Integer, Float> m : e.getValue().entrySet()) {
                switch (m.getKey()) {
                    case 0: {
                        rs.addValue("Naturalization R", (double)m.getValue().floatValue());
                        rs.addValue("Estimated R PSNR", this.calculate_PSNR(m.getValue().floatValue()));
                        break;
                    }
                    case 1: {
                        rs.addValue("Naturalization G", (double)m.getValue().floatValue());
                        rs.addValue("Estimated G PSNR", this.calculate_PSNR(m.getValue().floatValue()));
                        break;
                    }
                    case 2: {
                        rs.addValue("Naturalization B", (double)m.getValue().floatValue());
                        rs.addValue("Estimated B PSNR", this.calculate_PSNR(m.getValue().floatValue()));
                        break;
                    }
                    case 3: {
                        rs.addValue("Naturalization", (double)m.getValue().floatValue());
                        rs.addValue("Estimated PSNR", this.calculate_PSNR(m.getValue().floatValue()));
                        break;
                    }
                }
            }
        }
        if (!Interpreter.isBatchMode()) {
            rs.show("Naturalization and PSNR");
        }
    }

    private ImagePlus naturalize8bitImage(ByteProcessor imp, int aChannelNumber) {
        Img<UnsignedByteType> TChannel = ImagePlusAdapter.wrap((ImagePlus)new ImagePlus("", (ImageProcessor)imp));
        float T2_prior = this.T2_pr[aChannelNumber <= 2 ? 2 - aChannelNumber : 3];
        float[] result = new float[]{0.0f};
        TChannel = this.performNaturalization(TChannel, T2_prior, result);
        this.addPsnr(imp.getSliceNumber(), aChannelNumber, result[0]);
        return ImageJFunctions.wrap(TChannel, (String)"temporaryName");
    }

    private Img<UnsignedByteType> performNaturalization(Img<UnsignedByteType> channel, float T2_prior, float[] result) {
        FloatType Theta = new FloatType(0.5f);
        try {
            channel = this.doNaturalization(channel, Theta, UnsignedByteType.class, T2_prior, result);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return channel;
    }

    private <T extends NumericType<T> & NativeType<T>, S extends RealType<S>> Img<T> doNaturalization(Img<T> image_orig, S Theta, Class<T> cls_t, float T2_prior, float[] result) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        float Nf;
        if (image_orig == null) {
            return null;
        }
        NumericType image_check = (NumericType)cls_t.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        NumericType obj = image_check;
        if (!(obj instanceof UnsignedByteType)) {
            IJ.error((String)"Error it work only with 8-bit type");
            return null;
        }
        result[0] = Nf = this.findNaturalizationFactor(image_orig, Theta, T2_prior);
        Img<T> image_result = this.naturalizeImage(image_orig, Nf, cls_t);
        return image_result;
    }

    private <S extends RealType<S>, T extends NumericType<T> & NativeType<T>> Img<T> naturalizeImage(Img<T> image_orig, float Nf, Class<T> cls_t) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        float mean_original = 0.0f;
        Cursor c2 = image_orig.cursor();
        float count = 0.0f;
        while (c2.hasNext()) {
            c2.next();
            mean_original += ((RealType)c2.get()).getRealFloat();
            count += 1.0f;
        }
        mean_original /= count;
        long[] origImgDimensions = new long[2];
        image_orig.dimensions(origImgDimensions);
        Img image_result = image_orig.factory().create(origImgDimensions, (Object)((NumericType)cls_t.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
        Cursor cur_orig = image_orig.cursor();
        Cursor cur_ir = image_result.cursor();
        while (cur_orig.hasNext()) {
            cur_orig.next();
            cur_ir.next();
            float tmp = ((RealType)cur_orig.get()).getRealFloat();
            float Nat = (int)((double)((tmp - mean_original) * Nf + mean_original) + 0.5);
            if (Nat < 0.0f) {
                Nat = 0.0f;
            } else if (Nat > 255.0f) {
                Nat = 255.0f;
            }
            ((RealType)cur_ir.get()).setReal(Nat);
        }
        return image_result;
    }

    private <S extends RealType<S>, T extends NumericType<T> & NativeType<T>> float findNaturalizationFactor(Img<T> image_orig, S Theta, float T2prior) {
        ArrayImgFactory imgFactoryF = new ArrayImgFactory();
        Img LapCDF = imgFactoryF.create(new long[]{2041L}, (Object)new FloatType());
        Img GradCDF = imgFactoryF.create(new long[]{512L, 2L}, (Object)new FloatType());
        Img<FloatType> GradD = this.create2DGradientField();
        this.calculateLaplaceFieldAndGradient(image_orig, (Img<FloatType>)LapCDF, GradD);
        this.convertGrad2dToCDF(GradD);
        this.calculateGradCDF((Img<FloatType>)GradCDF, GradD);
        this.calculateLapCDF((Img<FloatType>)LapCDF);
        float T_tmp = (float)this.FindT((IterableInterval<FloatType>)Views.iterable((RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)GradCDF, (int)(GradCDF.numDimensions() - 1), (long)0L)), 512, 256, 1.0E-4f);
        T_tmp = (float)((double)T_tmp + this.FindT((IterableInterval<FloatType>)Views.iterable((RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)GradCDF, (int)(GradCDF.numDimensions() - 1), (long)1L)), 512, 256, 1.0E-4f));
        float T1 = T_tmp / 0.7508f;
        float T2 = (float)this.FindT((IterableInterval<FloatType>)LapCDF, 2041, 1020, 1.0E-4f) / T2prior;
        float Nf = (float)((1.0 - Theta.getRealDouble()) * (double)T1 + Theta.getRealDouble() * (double)T2);
        return Nf;
    }

    String calculate_PSNR(double x) {
        if (x >= 0.0 && x <= 0.934) {
            return String.format("%.2f", Float.valueOf((float)(23.65 * Math.exp(0.6 * x) - 20.0 * Math.exp(-7.508 * x))));
        }
        if (x > 0.934 && x < 1.07) {
            return new String("> 40");
        }
        if (x >= 1.07 && x < 1.9) {
            return String.format("%.2f", Float.valueOf((float)(-11.566 * x + 52.776)));
        }
        return String.format("%.2f", Float.valueOf((float)(13.06 * x * x * x * x - 121.4 * x * x * x + 408.5 * x * x - 595.5 * x + 349.0)));
    }

    private double FindT_Evalue(float[] p_d, int N, int offset, float T) {
        double error = 0.0;
        int i = -offset;
        while (i < N - offset) {
            double tmp = Math.atan(T * (float)i) - (double)p_d[i + offset];
            error += tmp * tmp;
            ++i;
        }
        return error;
    }

    private double FindT(IterableInterval<FloatType> data, int N, int OffSet, float eps) {
        float left = 0.0f;
        float right = 1.0f;
        float m1 = 0.0f;
        float m2 = 0.0f;
        float[] p_t = new float[N];
        Cursor cur_data = data.cursor();
        int i = 0;
        while (i < N) {
            cur_data.next();
            p_t[i] = (float)(((double)((FloatType)cur_data.get()).getRealFloat() - 0.5) * Math.PI);
            ++i;
        }
        while (right - left >= eps) {
            m1 = left + (right - left) / 3.0f;
            m2 = right - (right - left) / 3.0f;
            if (this.FindT_Evalue(p_t, N, OffSet, m1) <= this.FindT_Evalue(p_t, N, OffSet, m2)) {
                right = m2;
                continue;
            }
            left = m1;
        }
        return (m1 + m2) / 2.0f;
    }

    private Img<FloatType> create2DGradientField() {
        long[] dims = new long[]{512L, 512L};
        ArrayImg GradD = new ArrayImgFactory().create(dims, (NativeType)new FloatType());
        return GradD;
    }

    private void calculateLapCDF(Img<FloatType> LapCDF) {
        RandomAccess Lap_hist2 = LapCDF.randomAccess();
        int i = 1;
        while (i < 2041) {
            Lap_hist2.setPosition(i - 1, 0);
            float prec = ((FloatType)Lap_hist2.get()).getRealFloat();
            Lap_hist2.move(1, 0);
            ((FloatType)Lap_hist2.get()).set(((FloatType)Lap_hist2.get()).getRealFloat() + prec);
            ++i;
        }
    }

    private void calculateGradCDF(Img<FloatType> GradCDF, Img<FloatType> GradD) {
        RandomAccess Grad_dist = GradD.randomAccess();
        IntervalView Gradx = Views.hyperSlice(GradCDF, (int)(GradCDF.numDimensions() - 1), (long)0L);
        IntervalView Grady = Views.hyperSlice(GradCDF, (int)(GradCDF.numDimensions() - 1), (long)1L);
        this.integrateOverRowAndCol((RandomAccess<FloatType>)Grad_dist, (IntervalView<FloatType>)Gradx, (IntervalView<FloatType>)Grady);
        this.scaleGradients((IntervalView<FloatType>)Gradx, (IntervalView<FloatType>)Grady);
    }

    private void scaleGradients(IntervalView<FloatType> Gradx, IntervalView<FloatType> Grady) {
        RandomAccess Gradx_r2 = Gradx.randomAccess();
        RandomAccess Grady_r2 = Grady.randomAccess();
        int i = 0;
        while (i < 512) {
            Gradx_r2.setPosition(i, 0);
            Grady_r2.setPosition(i, 0);
            ((FloatType)Gradx_r2.get()).set((float)((double)((FloatType)Gradx_r2.get()).getRealFloat() / 255.0));
            ((FloatType)Grady_r2.get()).set((float)((double)((FloatType)Grady_r2.get()).getRealFloat() / 255.0));
            ++i;
        }
    }

    private void integrateOverRowAndCol(RandomAccess<FloatType> Grad_dist, IntervalView<FloatType> Gradx, IntervalView<FloatType> Grady) {
        int[] loc = new int[2];
        RandomAccess Gradx_r = Gradx.randomAccess();
        int i = 0;
        while (i < 512) {
            loc[1] = i;
            Gradx_r.setPosition(i, 0);
            int j = 0;
            while (j < 512) {
                loc[0] = j++;
                Grad_dist.setPosition(loc);
                ((FloatType)Gradx_r.get()).set(((FloatType)Gradx_r.get()).getRealFloat() + ((FloatType)Grad_dist.get()).getRealFloat());
            }
            ++i;
        }
        RandomAccess Grady_r = Grady.randomAccess();
        int i2 = 0;
        while (i2 < 512) {
            loc[1] = i2;
            Grady_r.setPosition(0, 0);
            int j = 0;
            while (j < 512) {
                loc[0] = j++;
                Grad_dist.setPosition(loc);
                ((FloatType)Grady_r.get()).set(((FloatType)Grady_r.get()).getRealFloat() + ((FloatType)Grad_dist.get()).getRealFloat());
                Grady_r.move(1, 0);
            }
            ++i2;
        }
    }

    private <T extends RealType<T>> void calculateLaplaceFieldAndGradient(Img<T> image, Img<FloatType> LapCDF, Img<FloatType> GradD) {
        RandomAccess Grad_dist = GradD.randomAccess();
        long[] origImgDimensions = new long[2];
        image.dimensions(origImgDimensions);
        ArrayImg laplaceField = new ArrayImgFactory().create(origImgDimensions, (NativeType)new FloatType());
        int[] indexD = new int[2];
        int[] loc_p = new int[2];
        RandomAccess img_cur = image.randomAccess();
        RandomAccess Lap_f = laplaceField.randomAccess();
        RandomAccess Lap_hist = LapCDF.randomAccess();
        long n_pixel = 1L;
        int i = 0;
        while (i < laplaceField.numDimensions()) {
            n_pixel *= laplaceField.dimension(i) - 2L;
            ++i;
        }
        double f = 1.0 / (double)n_pixel;
        Cursor cur = laplaceField.cursor();
        while (cur.hasNext()) {
            cur.next();
            cur.localize(loc_p);
            boolean border = false;
            int i2 = 0;
            while (i2 < image.numDimensions()) {
                if (loc_p[i2] == 0) {
                    border = true;
                } else if ((long)loc_p[i2] == image.dimension(i2) - 1L) {
                    border = true;
                }
                ++i2;
            }
            if (border) continue;
            img_cur.setPosition(loc_p);
            float L = -4.0f * ((RealType)img_cur.get()).getRealFloat();
            int i3 = 0;
            while (i3 < 2) {
                img_cur.move(1, i3);
                float G_p = ((RealType)img_cur.get()).getRealFloat();
                img_cur.move(-1, i3);
                float G_m = ((RealType)img_cur.get()).getRealFloat();
                img_cur.move(-1, i3);
                float L_m = ((RealType)img_cur.get()).getRealFloat();
                img_cur.setPosition(loc_p);
                L += G_p + L_m;
                indexD[1 - i3] = (int)(256.0f + G_p - G_m);
                ++i3;
            }
            Lap_f.setPosition(loc_p);
            ((FloatType)Lap_f.get()).setReal(L);
            Lap_hist.setPosition((int)(L += 1020.0f), 0);
            ((FloatType)Lap_hist.get()).setReal((double)((FloatType)Lap_hist.get()).getRealFloat() + f);
            Grad_dist.setPosition(indexD);
            ((FloatType)Grad_dist.get()).setReal((double)((FloatType)Grad_dist.get()).getRealFloat() + f);
        }
    }

    private void convertGrad2dToCDF(Img<FloatType> GradD) {
        float prec;
        int i;
        RandomAccess Grad_dist = GradD.randomAccess();
        int[] loc = new int[GradD.numDimensions()];
        int j = 0;
        while ((long)j < GradD.dimension(1)) {
            loc[1] = j;
            i = 1;
            while ((long)i < GradD.dimension(0)) {
                loc[0] = i - 1;
                Grad_dist.setPosition(loc);
                prec = ((FloatType)Grad_dist.get()).getRealFloat();
                Grad_dist.move(1, 0);
                ((FloatType)Grad_dist.get()).set(((FloatType)Grad_dist.get()).getRealFloat() + prec);
                ++i;
            }
            ++j;
        }
        j = 1;
        while ((long)j < GradD.dimension(1)) {
            loc[1] = j - 1;
            i = 0;
            while ((long)i < GradD.dimension(0)) {
                loc[0] = i++;
                Grad_dist.setPosition(loc);
                prec = ((FloatType)Grad_dist.get()).getRealFloat();
                Grad_dist.move(1, 1);
                ((FloatType)Grad_dist.get()).set(((FloatType)Grad_dist.get()).getRealFloat() + prec);
            }
            ++j;
        }
    }
}

