//Crop Mask Macro, Version 2.2

Dialog.create("Set parameters");
nDilate = 2; nClose = 5;
sigma = 4; tc = 0.8;//Similis -> 0.9
iterations = 2;//Similis -> 3
batch = true;
Dialog.addNumber("Blur sigma:", sigma);
Dialog.addNumber("2D Fill iterations:", nDilate);
Dialog.addNumber("3D Blur intensifier [0.05 - 1]:", tc, 1, 3, "");
Dialog.addNumber("3D Fill iterations:", iterations);
Dialog.addMessage("\n\n");
Dialog.addCheckbox("Run in background", true);
Dialog.show();
sigma = Dialog.getNumber();
nDilate = Dialog.getNumber();
tc = 1 - Dialog.getNumber();
if (tc <= 0) tc = 0.05;
if (tc >= 1) tc = 1.00;
iterations = Dialog.getNumber();
batch = Dialog.getCheckbox();
//===Pre-processing===//
//to clarify structure's shape
run("Gaussian Blur 3D...", "x=" + sigma + " y=" + sigma + " z=" + sigma/2);
setOption("BlackBackground", false);
setAutoThreshold("Triangle"); //default option
if (isOpen("Threshold"))
	selectWindow("Threshold");
else
	run("Threshold...");
waitForUser("Choose Threshold Method", "Then click OK.\nDo NOT press Apply/Auto.");
run("Convert to Mask", "method=" + getInfo("threshold.method") + " background=Light calculate");
selectWindow("Threshold");
run("Close");
setBatchMode(batch);
//2D Fill
for (i = 1; i <= nDilate; i++) {
	call("kn.uni.cls.ops.external.Process3dOp.dilate");
	//run("Dilate (3D)", "iso=255");
	run("Options...", "iterations=" + nClose + " count=1 do=Close stack");
	run("Fill Holes", "stack");
}
//===Execute===//
//3D Fill
for (i = 0; i < iterations; i++) {
	run("Gaussian Blur 3D...", "x=0 y=0 z=" + sigma);
	run("Gamma...", "value=" + tc + " stack");
	run("Convert to Mask", "method=IsoData background=Light calculate");
	run("Fill Holes", "stack");
}
//===Post-processing===//
for (i = 1; i <= nDilate; i++) {
	call("kn.uni.cls.ops.external.Process3dOp.erode");
	//run("Erode (3D)", "iso=255");
	run("Options...", "iterations=" + nClose + " count=1 do=Open stack");
}
run("Gaussian Blur 3D...", "x=1 y=1 z=1");
run("Convert to Mask", "method=Shanbhag background=Light calculate");
run("Remove Outliers...", "radius=32 threshold=50 which=Dark stack");
setBatchMode(false);
beep();
//EOF