//Crop Preprocessing Macro, Version 3

path = File.openDialog("Import Image Sequence");
if (path == "")
	return;
pathDir = substring(path, 0, lastIndexOf(path, File.separator));
name = substring(pathDir, lastIndexOf(pathDir, File.separator) + 1);
files = getFileList(pathDir);
outDir = getDirectory("Select Output Directory");

Dialog.create("Set Sequence Range");
number = 1;
starting = 1;
all = false;
Dialog.addNumber("Number of images:", number);
Dialog.addNumber("Starting image:", starting);
Dialog.addCheckbox(" Process whole stack", all);
Dialog.show();
number = Dialog.getNumber();
starting = Dialog.getNumber();
all = Dialog.getCheckbox();
imageSuffix = replace(files[starting - 1], "[^\\d]", "");

//Load and Pre-process
setBatchMode(true);
if (all)
	run("Image Sequence...", "open=["+ path + "] convert sort");
else
	run("Image Sequence...", "open=["+ path + "] number=" + number + " starting=" + starting + " convert sort");
call("kn.uni.cls.ops.external.MhBleachCorrectionOp.run");
close("Log");
call("kn.uni.cls.ops.external.NaturalizationOp.run");

//Binarize (Crop-Preprocess)
run("Smooth", "stack");
run("Find Edges", "stack");
run("Duplicate...", "duplicate");
selectWindow(name); //This time the original'll be the mask
run("Convert to Mask", "method=Triangle background=Dark calculate");
imageCalculator("Copy create stack", name, name + "-1");
close(name);
close(name + "-1");
selectWindow("Result of " + name);
rename(name);

//Remove the circular mask
run("Duplicate...", "duplicate");
selectWindow(name + "-1"); //dup image'll be the mask
run("Convert to Mask", "method=Triangle background=Light calculate");
run("Options...", "iterations=4 count=1 do=Dilate stack");
run("Fill Holes", "stack");
run("Options...", "iterations=8 count=1 do=Erode stack");
imageCalculator("AND create stack", name + "-1", name);
close(name);
close(name + "-1");
selectWindow("Result of " + name + "-1");
rename(name);

setBatchMode(false);
//preview = true;
//min = 0;
//max = 255;
//while (preview) {
//	Dialog.create("Globally Threshold Image");
//	Dialog.addNumber("Minimum:", min);
//	Dialog.addNumber("Maximum:", max);
//	Dialog.addCheckbox("Preview (on OK)", preview);
//	Dialog.show();
//	min = Dialog.getNumber();
//	max = Dialog.getNumber();
//	resetThreshold();
//	setThreshold(min, max);
//	preview = Dialog.getCheckbox();		
//}
//setBatchMode(true);
//run("Create Mask"); //doesn't work for stack!
if (isOpen("Threshold"))
	selectWindow("Threshold");
else
	run("Threshold...");
waitForUser("Choose Threshold Method", "Then click OK.\nDo NOT press Apply/Auto.");
setBatchMode(true);
run("Convert to Mask", "method=" + getInfo("threshold.method") + " background=Light calculate");
selectWindow("Threshold");
run("Close");

//Save
if (outDir != "") {
	if (!File.exists(outDir + "preproc"))
		File.makeDirectory(outDir + "preproc");
	run("Image Sequence... ", "format=TIFF name=" + name + "_binCropPreproc-" + " start=" + imageSuffix + " save=[" + outDir + "preproc/"
		+ name + "_binCropPreproc-"+ imageSuffix + ".tif]");
}

//Info
showMessage("The operation is complete!",
"<html>Now you can run <b>Plugins</b> &#10146; <b>BrainacleJ</b> &#10146; <b>2) Create Mask</b>.</html>");
setBatchMode(false);
//EOF
